<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateKebelesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('kebeles', function (Blueprint $table) {
            $table->id(); // Auto-incrementing primary key
            $table->string('name'); // Kebele name
            $table->foreignId('woreda_id')->constrained()->onDelete('cascade'); // FK to woredas
            $table->text('description')->nullable(); // Optional description
            $table->timestamps(); // created_at and updated_at
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('kebeles');
    }
}
